#version 430 core
layout(vertices = 3) out;

layout (location = 0) in vec2 vTexCoords[];
layout (location = 1) in vec4 vPosition[];
layout (location = 2) in vec2 vNoiseCoords[];
layout (location = 3) in vec3 vNormal[];
layout (location = 4) in vec3 vWorldPos[];

layout (location = 0) out vec2  tessTexCoords[];
layout (location = 1) out vec4  tessPosition[];
layout (location = 2) out vec2  tessNoiseCoords[];
layout (location = 3) out vec3  tessNormal[];

uniform int modelID;
uniform int currentPlanet;
uniform int nullplanet;
uniform int lodState;
uniform vec3 cameraPosition;


void main(void)
{
	float distanceFromCamera = length(cameraPosition - vWorldPos[gl_InvocationID]);
	
	float tessPowerInner = 1.0;
	float tessPowerOuter = 1.0;

	if(lodState == 1){
		float TessPower = 4.0 - (distanceFromCamera) / 500.0f;
		tessPowerInner = clamp(TessPower, 1.0, 3.0);
		tessPowerOuter = clamp(TessPower, 1.0, 3.0);
	}else{
		tessPowerInner = 3.0;
		tessPowerOuter = 3.0;
	}


	tessPosition[gl_InvocationID] = vPosition[gl_InvocationID];

	gl_TessLevelInner[0] = tessPowerInner;
	gl_TessLevelInner[1] = tessPowerInner;

	gl_TessLevelOuter[0] = tessPowerOuter;
	gl_TessLevelOuter[1] = tessPowerOuter;
	gl_TessLevelOuter[2] = tessPowerOuter;
	gl_TessLevelOuter[3] = tessPowerOuter;

	tessTexCoords[gl_InvocationID] = vTexCoords[gl_InvocationID];
	tessNoiseCoords[gl_InvocationID] = vNoiseCoords[gl_InvocationID];
	tessNormal[gl_InvocationID] = vNormal[gl_InvocationID];

}